#version 330
#extension GL_EXT_gpu_shader4 : enable
// Twisted Squares 2Mod01.fsh  by   jin_x
//https://www.shadertoy.com/view/sdy3Rh
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    // Normalize pixel coordinates (y = -0.5..0.5, x = -xres/yres/2..xres/yres/2)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    float ar = iResolution.x/iResolution.y;
    uv -= 0.5;
    uv.x *= ar;

    // Background
    float grad = cos(iTime);
    float mult = (sin((atan(uv.y, uv.x)+iTime*0.3)*20.)+.5)*.2;
    if (mult < 0.) { mult = 0.; }
    vec3 col = vec3(mult*(grad+.5), mult*(.5-grad), 0.);
    
    float size = .0025;
    grad = grad*.5 + .5;
    for (int i = 0; i < 100; ++i) {
        // Rotate image
        float a = iTime*(3.-float(i/2)*.07), sa = sin(a), ca = cos(a);
        vec2 uvr = uv * mat2(ca, -sa, sa, ca);
        // Calculate color
        if (abs(uvr.x) < size && abs(uvr.y) < size) {
            float rg = float(100-i)*.05;
            if ((i & 1) == 0) { col = vec3(rg*(1.-grad), rg*grad, 1.); }
            else { col = vec3(0.); }
            break;
        }
        size *= (i & 1) == 0 ? 1.075 : 1.025;
    }

    // Output to screen
    gl_FragColor = vec4(col, 1.0);
}
